<style>
	.rating-label{
		display:none;
	}
	.taglib-ratings{
		display:inline;
	}

</style>

<#assign dateFormat = "dd.MM.yyyy" />
<ul class="news_list list-unstyled">
	
	<#if entries?has_content>
		<#list entries as entry>
			<#assign
				entryId = entry.getEntryId()
				assetRenderer = entry.getAssetRenderer()
				entryTitle = htmlUtil.escape(assetRenderer.getTitle(locale))
				viewURL = assetPublisherHelper.getAssetViewURL(renderRequest, renderResponse, entry, true)
			/>
			
			<li>
				 <div class="date color_red">${dateUtil.getDate(entry.getModifiedDate(), dateFormat, locale)}</div>
				 <a href="/news/-/asset_publisher/9xAOHYKe6IcV/content/${assetRenderer.getUrlTitle()}?redirect=main">
					${entry.getTitle(locale)}
				</a>
				
				<div class="metadata-entry metadata-view-count">

					<@liferay_ui["icon"]
						image="view_count"
					/>
					${entry.getViewCount()}
					
				</div>
				<hr/>
			</li>
		</#list>
	</#if>

</ul>


<#macro getRatings>
	<#if (enableRatings == "true")>
		<div class="asset-ratings">
			<@liferay_ui["ratings"]
				className=entry.getClassName()
				classPK=entry.getClassPK()
			/>
		</div>
	</#if>
</#macro>

<#macro getMetadataField fieldName>
	<#if stringUtil.split(metadataFields)?seq_contains(metadataFieldName)>
		<span class="metadata-entry metadata-"${metadataFieldName}">
			<#assign dateFormat = "dd MMM yyyy - HH:mm:ss" />

			<#if fieldName == "author">
				<@liferay.language key="by" /> ${portalUtil.getUserName(assetRenderer.getUserId(), assetRenderer.getUserName())}
			<#elseif fieldName == "categories">
				<@liferay_ui["asset-categories-summary"]
					className=entry.getClassName()
					classPK=entry.getClassPK()
					portletURL=renderResponse.createRenderURL()
				/>
			<#elseif fieldName == "create-date">
				${dateUtil.getDate(entry.getCreateDate(), dateFormat, locale)}
			<#elseif fieldName == "expiration-date">
				${dateUtil.getDate(entry.getExpirationDate(), dateFormat, locale)}
			<#elseif fieldName == "modified-date">
				${dateUtil.getDate(entry.getModifiedDate(), dateFormat, locale)}
			<#elseif fieldName == "priority">
				${entry.getPriority()}
			<#elseif fieldName == "publish-date">
				${ddateUtil.getDate(entry.getPublishDate(), dateFormat, locale)}
			<#elseif fieldName == "tags">
				<@liferay_ui["asset-tags-summary"]
					className=entry.getClassName()
					classPK=entry.getClassPK()
					portletURL=renderResponse.createRenderURL()
				/>
			<#elseif fieldName == "view-count">
				<@liferay_ui["icon"]
					image="history"
				/>

				${entry.getViewCount()} <@liferay.language key="views" />
			</#if>
		</span>
	</#if>
</#macro>